%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% @description LaTeX class for the Journal of Simulation Engineering
%% @author Luis Gustavo Nardin <nardin@b-tu.de>
%% @author Gerd Wagner <wagnerg@b-tu.de>
%% @created 2018-11-12
%% @version 0.1.2
%% @changes [2018-11-12 v0.1.0] Class created
%% @changes [2019-01-24 v0.1.1] Changed from bibtex/natlib to biber/biblatex
%% @changes [2019-02-18 v0.1.2] Changed back to bibtex/natlib
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{jsime}[2019/02/18]

%% Load default article LaTeX class
\LoadClass[onecolumn,a4paper,12pt]{article}
\DeclareOption{twocolumn}{\OptionNotUsed}
\DeclareOption{letter}{\OptionNotUsed}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}
\ProcessOptions\relax

\RequirePackage{times}
\RequirePackage{mathptmx}

\RequirePackage[T1]{fontenc}
\RequirePackage[utf8]{inputenc}
\RequirePackage[english]{babel}

\RequirePackage{algorithm,algorithmic}
\RequirePackage{amsmath,amsfonts,amssymb,amsthm}
\RequirePackage{ifthen,ifpdf}
\RequirePackage{microtype}
\RequirePackage{epsfig,graphicx}
\RequirePackage{xcolor}
\RequirePackage{subcaption}
\RequirePackage{booktabs}
\RequirePackage{paralist}
\RequirePackage{lastpage}
\RequirePackage{lineno}
\RequirePackage{xspace}

%-----------------------------------------------
%% Trackchanges
\newboolean{trackchanges}
\def\trackchanges#1{\setboolean{trackchanges}{#1}}

%% ADD command
\newcommand{\add}[1]{
  \ifthenelse{\boolean{trackchanges}}
  {
    \colorlet{currentcolor}{.}
    \color{blue}#1\xspace\color{currentcolor}
  }
  {
    #1\xspace
  }
}

%% CHANGE command
\newcommand{\change}[2]{
  \ifthenelse{\boolean{trackchanges}}
  {
    \colorlet{currentcolor}{.}
    \color{red}[#1]\color{blue}#2\xspace\color{currentcolor}
  }
  {
    #2\xspace
  }
}

%% REMOVE command
\newcommand{\remove}[1]{
  \ifthenelse{\boolean{trackchanges}}
  {
    \colorlet{currentcolor}{.}
    \color{red}#1\xspace\color{currentcolor}
  }
  {
    #1
  }
}

%-----------------------------------------------
%% New commands
\newboolean{finalversion}
\def\finalversion#1{\setboolean{finalversion}{#1}}

\newcommand{\volume}[1]{\def \@volume{#1}}
\volume{V}

\newcommand{\article}[1]{\def \@article{#1}}
\article{A}

\newcommand{\pubyear}[1]{\def \@pubyear{#1}}
\pubyear{YYYY}

\newcommand{\titleabbr}[1]{\def \@titleabbr{#1}}
\titleabbr{\@title}

%-----------------------------------------------
%% Authors and Affiliations
\RequirePackage[noblocks]{authblk}
\renewcommand\Authfont{\fontsize{16}{18}\itshape}
\renewcommand\Affilfont{\normalfont\fontsize{10}{12}\itshape}
\renewcommand\Authsep{, }
\renewcommand\Authand{ and }
\renewcommand\Authands{, and }

%-----------------------------------------------
%% General aspects and page formating
\RequirePackage[top = 2cm,
                left = 2.5cm,
                right = 2.5cm,
                bottom = 3cm]{geometry}

%-----------------------------------------------
% Headers and footers
\RequirePackage[pdftex,colorlinks=true,urlcolor=black,citecolor=black,anchorcolor=black,linkcolor=black,filecolor=black]{hyperref}
\renewcommand\UrlFont{\rmfamily}
\RequirePackage{fancyhdr}
\setlength{\headheight}{15pt}
\fancypagestyle{titlepagestyle}{
  \fancyhead{}
  \fancyhead[C]{\small \textit{Journal of Simulation Engineering}, Volume \@volume\ (\@pubyear). Article URL: {\scriptsize \url{https://articles.jsime.org/\@volume/\@article}}}
  \fancyfoot{}
  \fancyfoot[R]{\@article:\thepage\ / \@article:\pageref{LastPage}}
  \renewcommand{\headrulewidth}{0pt}
}

\fancypagestyle{pagestyle}{
  \fancyhead{}
  \fancyhead[C]{\@titleabbr}
  \fancyfoot{}
  \fancyfoot[R]{\@article:\thepage\ / \@article:\pageref{LastPage}}
  \renewcommand{\headrulewidth}{0pt}
}

\RequirePackage{endnotes}
\renewcommand{\footnotesize}{\normalsize}

%-----------------------------------------------
%% References
\RequirePackage{natbib}
\setcitestyle{authoryear,round,aysep={}}
\bibliographystyle{apalike}

%-----------------------------------------------
%% Section/Subsections/Subsubsections/Paragraphs
\RequirePackage[explicit]{titlesec}
\titleformat{\section}
  {\color{black}\fontsize{14}{16}\bfseries}
  {\thesection}
  {0.5em}
  {#1}
  []
\titleformat{name=\section,numberless}
  {\color{black}\fontsize{14}{16}\bfseries}
  {}
  {0em}
  {#1}
  []
\titleformat{\subsection}
  {\fontsize{12}{14}\bfseries}
  {\thesubsection}
  {0.5em}
  {#1}
  []
\titleformat{\subsubsection}
  {\fontsize{11}{12}\bfseries}
  {\thesubsubsection}
  {0.5em}
  {#1}
  []
\titleformat{\paragraph}[runin]
  {\bfseries}
  {}
  {0em}
  {#1}
\titlespacing*{\section}{0pc}{3ex \@plus4pt \@minus3pt}{5pt}
\titlespacing*{\subsection}{0pc}{2.5ex \@plus3pt \@minus2pt}{5pt}
\titlespacing*{\subsubsection}{0pc}{2ex \@plus2.5pt \@minus1.5pt}{5pt}
\titlespacing*{\paragraph}{0pc}{1.5ex \@plus2pt \@minus1pt}{10pt}

%-----------------------------------------------
%% Title
\renewcommand{\maketitle}{
  \thispagestyle{titlepagestyle}
  \vskip-36pt
  {\raggedright\bfseries\fontsize{20}{24}\selectfont \@title\par}
  \vskip20pt
  {\ifthenelse{\boolean{finalversion}}
    {\raggedright\fontsize{12}{12}\selectfont \@author\par}
    {\textit{Anonymized for Review}}
  }
  \vskip25pt
  \pagestyle{pagestyle}
}

%-----------------------------------------------
%% ACM Categories
\newenvironment{categories}[1]{
  \noindent
  {
  \color{black}\fontsize{14}{14}\textbf{ACM Subject Categories}
  }
  \begin{itemize}{
    \setlength{\leftmargin}{0cm}
    \setlength{\rightmargin}{\leftmargin}
  }
  \@for\next:=#1\do{\item\next\relax}
  \end{itemize}
}

%-----------------------------------------------
%% Keywords
\newenvironment{keywords}{
  \par
  \noindent
  {

  \noindent\color{black}\fontsize{14}{14}\textbf{Keywords}
  }
  \list{}{
    \setlength{\leftmargin}{0cm}
    \setlength{\rightmargin}{\leftmargin}
  }
  \item\relax
}
{\endlist}

%-----------------------------------------------
%% Abstract
\renewenvironment{abstract}{
  \par
  \noindent
  {

  \noindent\parbox{\dimexpr\linewidth-2\fboxsep\relax}{\color{black}\fontsize{14}{14}\textbf{Abstract}}}
  \list{}{
    \setlength{\leftmargin}{0cm}
    \setlength{\rightmargin}{\leftmargin}
  }
  \item\relax
  \ifthenelse{\boolean{finalversion}}{\nolinenumbers}{\linenumbers}
}
{\endlist}

%-----------------------------------------------
%% Acknowledgment
 \newenvironment{acknowledgements}[1]{
  \par
  \noindent
  {

  \noindent\parbox{\dimexpr\linewidth-2\fboxsep\relax}{\color{black}\fontsize{14}{14}\textbf{Acknowledgements}}
  }
  \setlength{\leftmargin}{0cm}
  \setlength{\rightmargin}{\leftmargin}
  \ifthenelse{\boolean{finalversion}}{
    \par
    #1
  }
  {
    \par
    {\textit{Anonymized for Review}}
  }
}
{\endlist}